/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.handlers.pages;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.jstestdriver.server.handlers.pages.Page;
import com.google.jstestdriver.server.handlers.pages.SlavePageRequest;
import com.google.jstestdriver.server.handlers.pages.TestFileUtil;
import com.google.jstestdriver.util.HtmlWriter;
import java.io.IOException;

public class RunnerPage
implements Page {
    private final TestFileUtil testFileUtil;
    private final Boolean debug;

    @Inject
    RunnerPage(TestFileUtil testFileUtil, @Named(value="debug") Boolean debug) {
        this.testFileUtil = testFileUtil;
        this.debug = debug;
    }

    public void render(HtmlWriter writer, SlavePageRequest request) throws IOException {
        writer.startHead().writeTitle("Console Runner").writeScript("var start = new Date().getTime();").writeExternalScript("/static/lib/json2.js").writeExternalScript("/static/lib/json_sans_eval.js").writeExternalScript("/static/jstestdrivernamespace.js").writeExternalScript("/static/lib/jquery-min.js").writeExternalScript("/static/runner.js").writeScript("jstestdriver.runConfig = {'debug':" + this.debug + "};").writeScript("jstestdriver.console = new jstestdriver.Console();\njstestdriver.runner = jstestdriver.config.createRunner(\n    jstestdriver.config.createExecutor,\n    jstestdriver.plugins.createPausingRunTestLoop(\n        jstestdriver.TIMEOUT,\n        jstestdriver.now,\n        jstestdriver.setTimeout));").writeScript("jstestdriver.log('runner loaded in ' + (new Date().getTime() - start));start = new Date().getTime();");
        if (!"load".equals(request.getParameter("load_type"))) {
            this.testFileUtil.writeTestFiles(writer, request.getParameter("testcase_id"));
        }
        writer.writeScript("jstestdriver.log('test loaded in ' + (new Date().getTime() - start));jstestdriver.jQuery(window).load(function(){jstestdriver.runner.listen(jstestdriver.manualResourceTracker.getResults());});");
        writer.finishHead().startBody().finishBody().flush();
    }
}

