/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.handlers;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.jstestdriver.SlaveBrowser;
import com.google.jstestdriver.UserAgentParser;
import com.google.jstestdriver.browser.BrowserHunter;
import com.google.jstestdriver.requesthandlers.RequestHandler;
import com.google.jstestdriver.runner.RunnerType;
import com.google.jstestdriver.server.handlers.pages.SlavePageRequest;
import com.google.jstestdriver.util.ParameterParser;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptureHandler
implements RequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(CaptureHandler.class);
    public static final String RUNNER_TYPE = "rt";
    private static final String TIMEOUT = "timeout";
    public static final String STRICT = "strict";
    public static final String QUIRKS = "quirks";
    private static final Map<String, Integer> PARAMETERS = ImmutableMap.builder().put("strict", 0).put("quirks", 0).put("rt", 1).put("upload_size", 1).put("mode", 1).put("id", 1).put("timeout", 1).put("testcase_id", 1).build();
    private static final Set<String> BLACKLIST = ImmutableSet.builder().add("capture").build();
    private final SlavePageRequest request;
    private final HttpServletResponse response;
    private final BrowserHunter browserHunter;
    private final ParameterParser restParser;

    @Inject
    public CaptureHandler(SlavePageRequest request, HttpServletResponse response, BrowserHunter browserHunter, ParameterParser restParser) {
        this.browserHunter = browserHunter;
        this.request = request;
        this.response = response;
        this.restParser = restParser;
    }

    public void handleIt() throws IOException {
        Map<String, String> parameterMap = this.restParser.getParameterMap(PARAMETERS, BLACKLIST);
        String mode = parameterMap.get(STRICT) != null ? STRICT : QUIRKS;
        String id = parameterMap.get("id");
        RunnerType runnerType = this.parseRunnerType(parameterMap.get(RUNNER_TYPE));
        Long timeout = this.parseLong(parameterMap.get(TIMEOUT));
        Integer uploadSize = this.parseInteger(parameterMap.get("upload_size"));
        String redirect = this.service(this.request.getUserAgent(), mode, id, runnerType, timeout, uploadSize);
        logger.debug("Redirecting to {}", (Object)redirect);
        this.response.sendRedirect(redirect);
    }

    private Integer parseInteger(String value) {
        return value == null ? null : Integer.valueOf(Integer.parseInt(value));
    }

    private Long parseLong(String value) {
        return value == null ? null : Long.valueOf(Long.parseLong(value));
    }

    private RunnerType parseRunnerType(String runnerType) {
        return runnerType == null ? RunnerType.CLIENT : RunnerType.valueOf(runnerType.toUpperCase());
    }

    public String service(String userAgent, String mode, String id, RunnerType runnerType, Long timeout, Integer uploadSize) {
        UserAgentParser parser = new UserAgentParser();
        parser.parse(userAgent);
        SlaveBrowser slaveBrowser = this.browserHunter.captureBrowser(id, parser.getName(), parser.getVersion(), parser.getOs(), timeout, mode, runnerType, uploadSize);
        return slaveBrowser.getCaptureUrl();
    }
}

