/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileLoader;
import com.google.jstestdriver.FileSource;
import com.google.jstestdriver.JsTestDriverFileFilter;
import com.google.jstestdriver.JsonCommand;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.Server;
import com.google.jstestdriver.StreamMessage;
import com.google.jstestdriver.browser.BrowserFileSet;
import com.google.jstestdriver.hooks.FileInfoScheme;
import com.google.jstestdriver.model.HandlerPathPrefix;
import com.google.jstestdriver.model.JstdTestCase;
import com.google.jstestdriver.model.JstdTestCaseDelta;
import com.google.jstestdriver.util.StopWatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUploader {
    public static final int CHUNK_SIZE = 50;
    private final StopWatch stopWatch;
    private final Gson gson = new Gson();
    private final Server server;
    private final String baseUrl;
    private final FileLoader fileLoader;
    private final JsTestDriverFileFilter filter;
    private final Set<FileInfoScheme> schemes;
    private static final Logger logger = LoggerFactory.getLogger(FileUploader.class);
    private final HandlerPathPrefix prefix;

    @Inject
    public FileUploader(StopWatch stopWatch, Server server, @Named(value="server") String baseUrl, FileLoader fileLoader, JsTestDriverFileFilter filter, Set<FileInfoScheme> schemes, @Named(value="serverHandlerPrefix") HandlerPathPrefix prefix) {
        this.stopWatch = stopWatch;
        this.server = server;
        this.baseUrl = baseUrl;
        this.fileLoader = fileLoader;
        this.filter = filter;
        this.schemes = schemes;
        this.prefix = prefix;
    }

    public void uploadFileSet(String browserId, Collection<JstdTestCase> testCases, ResponseStream stream) {
        this.stopWatch.start("determineServerFileSet(%s)", browserId);
        Collection<JstdTestCaseDelta> deltas = this.determineServerFileSet(testCases);
        this.stopWatch.stop("determineServerFileSet(%s)", browserId);
        logger.debug("Deltas: {}", deltas);
        this.stopWatch.start("upload to server %s", browserId);
        this.uploadToServer(deltas);
        this.stopWatch.stop("upload to server %s", browserId);
        for (JstdTestCase testCase : testCases) {
            this.stopWatch.start("determineBrowserFileSet(%s)", browserId);
            List<FileInfo> browserFilesToUpdate = this.determineBrowserFileSet(browserId, testCase, stream);
            this.stopWatch.stop("determineBrowserFileSet(%s)", browserId);
            this.stopWatch.start("uploadToTheBrowser(%s)", browserId);
            this.uploadToTheBrowser(browserId, stream, browserFilesToUpdate, 50);
            this.stopWatch.stop("uploadToTheBrowser(%s)", browserId);
        }
    }

    public Collection<JstdTestCaseDelta> determineServerFileSet(Collection<JstdTestCase> testCases) {
        LinkedHashMap<String, String> fileSetParams = new LinkedHashMap<String, String>();
        fileSetParams.put("data", this.gson.toJson(testCases));
        fileSetParams.put("action", "serverFileUpload");
        String postResult = this.server.post(this.baseUrl + "/fileSet", fileSetParams);
        return (Collection)this.gson.fromJson(postResult, new TypeToken<Collection<JstdTestCaseDelta>>(){}.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileInfo> determineBrowserFileSet(String browserId, JstdTestCase testCase, ResponseStream stream) {
        ArrayList<FileInfo> arrayList;
        BrowserFileSet browserFileSet = this.getBrowserFileSet(browserId, testCase);
        this.stopWatch.start("resolving browser upload %s", browserId);
        try {
            logger.debug("Updating files {}", browserFileSet.getFilesToUpload());
            LinkedHashSet<FileInfo> finalFilesToUpload = new LinkedHashSet<FileInfo>();
            if (browserFileSet.shouldReset() || !browserFileSet.getExtraFiles().isEmpty()) {
                this.reset(browserId, stream, testCase);
                browserFileSet = this.getBrowserFileSet(browserId, testCase);
                logger.info("second fileset {}", browserFileSet);
            }
            for (FileInfo file : browserFileSet.getFilesToUpload()) {
                finalFilesToUpload.addAll(this.determineInBrowserDependencies(file, testCase.getServable()));
            }
            arrayList = Lists.newArrayList(finalFilesToUpload);
        }
        catch (Throwable throwable) {
            this.stopWatch.stop("resolving browser upload %s", browserId);
            throw throwable;
        }
        this.stopWatch.stop("resolving browser upload %s", browserId);
        return arrayList;
    }

    private BrowserFileSet getBrowserFileSet(String browserId, JstdTestCase testCase) {
        this.stopWatch.start("get upload set %s", browserId);
        LinkedHashMap<String, String> fileSetParams = new LinkedHashMap<String, String>();
        fileSetParams.put("id", browserId);
        fileSetParams.put("data", this.gson.toJson(testCase));
        fileSetParams.put("action", "browserFileCheck");
        String postResult = this.server.post(this.baseUrl + "/fileSet", fileSetParams);
        if (postResult.length() < 0) {
            return new BrowserFileSet(Collections.<FileInfo>emptyList(), Collections.<FileInfo>emptyList(), false);
        }
        BrowserFileSet browserFileSet = this.gson.fromJson(postResult, BrowserFileSet.class);
        this.stopWatch.stop("get upload set %s", browserId);
        return browserFileSet;
    }

    public void uploadToTheBrowser(String browserId, ResponseStream stream, List<FileInfo> loadedFiles, int chunkSize) {
        LinkedList<FileSource> filesSrc = Lists.newLinkedList(this.filterFilesToLoad(loadedFiles));
        int numberOfFilesToLoad = filesSrc.size();
        logger.info("Files toupload {}", Lists.transform(Lists.newArrayList(loadedFiles), new Function<FileInfo, String>(){

            @Override
            public String apply(FileInfo in) {
                return "\n" + in.getDisplayPath();
            }
        }));
        for (int i = 0; i < numberOfFilesToLoad; i += chunkSize) {
            Response response;
            StreamMessage message;
            int chunkEndIndex = Math.min(i + chunkSize, numberOfFilesToLoad);
            LinkedList<String> loadParameters = new LinkedList<String>();
            List filesToLoad = filesSrc.subList(i, chunkEndIndex);
            loadParameters.add(this.gson.toJson(filesToLoad));
            loadParameters.add("false");
            JsonCommand cmd = new JsonCommand(JsonCommand.CommandType.LOADTEST, loadParameters);
            LinkedHashMap<String, String> loadFileParams = new LinkedHashMap<String, String>();
            loadFileParams.put("id", browserId);
            loadFileParams.put("data", this.gson.toJson(cmd));
            if (logger.isDebugEnabled()) {
                logger.debug("Sending LOADTEST to {} for {}", (Object)browserId, Lists.transform(filesToLoad, new Function<FileSource, String>(){

                    @Override
                    public String apply(FileSource in) {
                        return "\n" + in.getFileSrc();
                    }
                }));
            }
            this.server.post(this.baseUrl + "/cmd", loadFileParams);
            do {
                String jsonResponse = this.server.fetch(this.baseUrl + "/cmd?id=" + browserId);
                message = this.gson.fromJson(jsonResponse, StreamMessage.class);
                response = message.getResponse();
                logger.trace("LOADTEST response for {}", response);
                stream.stream(response);
            } while (!message.isLast());
            logger.debug("Finished LOADTEST on {} with {}", (Object)browserId, (Object)response.getResponseType());
        }
    }

    public void uploadToServer(Collection<JstdTestCaseDelta> deltas) {
        if (deltas.isEmpty()) {
            return;
        }
        ArrayList<JstdTestCaseDelta> loadedDeltas = Lists.newArrayListWithCapacity(deltas.size());
        for (JstdTestCaseDelta delta : deltas) {
            loadedDeltas.add(delta.loadFiles(this.fileLoader));
        }
        LinkedHashMap<String, String> uploadFileParams = new LinkedHashMap<String, String>();
        uploadFileParams.put("action", "deltaUpdate");
        uploadFileParams.put("data", this.gson.toJson(loadedDeltas));
        this.server.post(this.baseUrl + "/fileSet", uploadFileParams);
    }

    private void reset(String browserId, ResponseStream stream, JstdTestCase testCase) {
        StreamMessage message;
        Response response;
        this.stopWatch.start("reset %s", browserId);
        JsonCommand cmd = new JsonCommand(JsonCommand.CommandType.RESET, Lists.newArrayList("preload", testCase.getId()));
        LinkedHashMap<String, String> resetParams = new LinkedHashMap<String, String>();
        logger.debug("reset browser {}  testcase {}", (Object)browserId, (Object)testCase.getId());
        resetParams.put("id", browserId);
        resetParams.put("data", this.gson.toJson(cmd));
        this.server.post(this.baseUrl + "/cmd", resetParams);
        logger.trace("starting reset for {}", (Object)browserId);
        do {
            String jsonResponse = this.server.fetch(this.baseUrl + "/cmd?id=" + browserId);
            message = this.gson.fromJson(jsonResponse, StreamMessage.class);
            response = message.getResponse();
            stream.stream(response);
        } while (!Response.ResponseType.RESET_RESULT.equals((Object)response.getResponseType()) || !message.isLast());
        logger.trace("finished reset for {}", (Object)browserId);
        this.stopWatch.stop("reset %s", browserId);
    }

    private Collection<FileInfo> determineInBrowserDependencies(FileInfo file, List<FileInfo> files) {
        LinkedHashSet<FileInfo> deps = Sets.newLinkedHashSet();
        for (FileInfo dep : this.filter.resolveFilesDeps(file, files)) {
            deps.add(dep);
        }
        return deps;
    }

    private List<FileSource> filterFilesToLoad(Collection<FileInfo> fileInfos) {
        LinkedList<FileSource> filteredFileSources = new LinkedList<FileSource>();
        for (FileInfo fileInfo : fileInfos) {
            if (fileInfo.isServeOnly()) continue;
            filteredFileSources.add(fileInfo.toFileSource(this.prefix, this.schemes));
        }
        return filteredFileSources;
    }
}

