/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.FileReader;
import com.google.jstestdriver.FileSource;
import com.google.jstestdriver.hooks.FileInfoScheme;
import com.google.jstestdriver.model.HandlerPathPrefix;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileInfo
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(FileInfo.class);
    private String filePath;
    private Long timestamp;
    private transient boolean isPatch;
    private boolean serveOnly;
    private List<FileInfo> patches;
    private String data;
    private long length;
    private String displayPath;

    public FileInfo() {
    }

    public FileInfo(String filePath, long timestamp, long length, boolean isPatch, boolean serveOnly, String data, String displayPath) {
        this.filePath = filePath;
        this.timestamp = timestamp;
        this.length = length;
        this.isPatch = isPatch;
        this.serveOnly = serveOnly;
        this.data = data;
        this.displayPath = displayPath;
    }

    public String getData() {
        return this.data == null ? "" : this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public List<FileInfo> getPatches() {
        if (this.patches != null) {
            return new LinkedList<FileInfo>(this.patches);
        }
        return new LinkedList<FileInfo>();
    }

    public void addPatch(FileInfo patch) {
        if (this.patches == null) {
            this.patches = new LinkedList<FileInfo>();
        }
        this.patches.add(patch);
    }

    public long getLength() {
        return this.length;
    }

    public boolean isServeOnly() {
        return this.serveOnly;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean isPatch() {
        return this.isPatch;
    }

    public boolean isWebAddress() {
        return this.filePath.startsWith("http://") || this.filePath.startsWith("https://");
    }

    public boolean canLoad() {
        return !this.isWebAddress();
    }

    public boolean isLoaded() {
        return this.data != null;
    }

    public File toFile(File basePath) {
        return new File(this.filePath);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filePath == null ? 0 : this.filePath.hashCode());
        result = 31 * result + (this.serveOnly ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileInfo)) {
            return false;
        }
        FileInfo other = (FileInfo)obj;
        if (this.filePath == null && other.filePath != null) {
            return false;
        }
        if (!this.filePath.equals(other.filePath)) {
            return false;
        }
        return this.serveOnly == other.serveOnly;
    }

    public FileInfo load(String data, long timestamp) {
        return new FileInfo(this.filePath, timestamp, this.length, this.isPatch, this.serveOnly, data, this.displayPath);
    }

    public FileSource toFileSource(HandlerPathPrefix prefix, Set<FileInfoScheme> schemes) {
        for (FileInfoScheme scheme : schemes) {
            if (!scheme.matches(this.filePath)) continue;
            return new FileSource(this.displayPath, this.filePath, this.getTimestamp(), this.length);
        }
        return new FileSource(prefix.prefixPath("/test/" + this.getDisplayPath()), this.filePath, this.getTimestamp(), this.length);
    }

    public String toString() {
        if (logger.isDebugEnabled() || logger.isTraceEnabled()) {
            return "\n\tFileInfo [filePath=" + this.filePath + ", length=" + this.length + ", patches=" + this.patches + ", serveOnly=" + this.serveOnly + ", timestamp=" + this.timestamp + "]";
        }
        return "\n\tFileInfo[" + this.getDisplayPath() + "]";
    }

    public FileInfo fromResolvedPath(String resolvedPath, String displayPath, long timestamp) {
        return new FileInfo(resolvedPath, timestamp, this.length, this.isPatch, this.serveOnly, this.data, displayPath);
    }

    public String getDisplayPath() {
        return this.displayPath;
    }

    public FileInfo loadFile(FileReader reader, File basePath) {
        if (!this.canLoad()) {
            return this;
        }
        StringBuilder fileContent = new StringBuilder();
        fileContent.append(reader.readFile(this.filePath));
        List<FileInfo> patches = this.getPatches();
        if (patches != null) {
            for (FileInfo patch : patches) {
                fileContent.append(reader.readFile(patch.getFilePath()));
            }
        }
        return this.load(fileContent.toString(), this.timestamp);
    }

    protected Object clone() throws CloneNotSupportedException {
        return new FileInfo(this.filePath, this.timestamp, this.length, this.isPatch, this.serveOnly, this.data, this.displayPath);
    }

    public boolean shouldReplaceWith(FileInfo file) {
        if (!this.filePath.equals(file.getFilePath())) {
            logger.trace("paths not equal {} {}", (Object)this.getDisplayPath(), (Object)file.getDisplayPath());
            return false;
        }
        if (this.getTimestamp() != file.getTimestamp()) {
            logger.trace("replace {} because {} != {}", new Object[]{this.getDisplayPath(), this.getTimestamp(), file.getTimestamp()});
            return true;
        }
        return false;
    }
}

